using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using System.Collections.Generic;
using System.IO;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieProfile
		{
			
			
			public class MovieImagesBO : StrataFlix.Business.MovieImagesBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("mi_PosterLargeAsBinary", typeof(MovieImagesBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// Used within the RDL reports since a database image expects a byte array.  If using
				/// a reporting engine such as Report Sharp-Shooter, this would not be necessary.
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public byte[] mi_PosterLargeAsBinary
				{
					get
					{
						//-- Establish Locals
						MemoryStream memStream = new MemoryStream();
						
						//-- Save the image to the memory stream
						mi_PosterLarge.Save(memStream, System.Drawing.Imaging.ImageFormat.Png);
						
						//-- Return as a byte array
						memStream.Seek(0, SeekOrigin.Begin);
						return memStream.ToArray();
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
